;***********************************************************************************************************************
;*   SUPER_JOYSTICK_PORT_2.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;***********************************************************************************************************************

;***********************************************************************************************************************
;*    "SUPER JOYSTICK PORT 2"
;*
;*  = ATMEGA48PA-AU   11,0592 
;*     = ConTEXT
;*  = ASM32
;*    = AVRDUDE  
;*  = "FT232 AVR PROG" (ZXkit-029)
;*
;* 150213-02
;***********************************************************************************************************************

.include "m48def.inc"
.include "MACRO.asm"
.include "EQU.asm"
.include "DEF.asm"

;***********************************************************************************************************************
;* 150213-02                               
;***********************************************************************************************************************
.org    $000
        rjmp RESET                      ; Reset Handler
reti;   rjmp EXT_INT0                   ; IRQ0 Handler
        rjmp EXT_INT1                   ; IRQ1 Handler             -   PS2/
reti;   rjmp PCINT0                     ; PCINT0 Handler
reti;   rjmp PCINT1                     ; PCINT1 Handler
reti;   rjmp PCINT2                     ; PCINT2 Handler
reti;   rjmp WDT                        ; Watchdog Timer Handler
reti;   rjmp TIM2_COMPA                 ; Timer2 Compare A Handler
reti;   rjmp TIM2_COMPB                 ; Timer2 Compare B Handler
reti;   rjmp TIM2_OVF                   ; Timer2 Overflow Handler
reti;   rjmp TIM1_CAPT                  ; Timer1 Capture Handler
reti;   rjmp TIM1_COMPA                 ; Timer1 Compare A Handler
reti;   rjmp TIM1_COMPB                 ; Timer1 Compare B Handler
reti;   rjmp TIM1_OVF                   ; Timer1 Overflow Handler
        rjmp TIM0_COMPA                 ; Timer0 Compare A Handler -    SEGA 
reti;   rjmp TIM0_COMPB                 ; Timer0 Compare B Handler
reti;   rjmp TIM0_OVF                   ; Timer0 Overflow Handler
reti;   rjmp SPI_STC                    ; SPI Transfer Complete Handler
reti;   rjmp USART_RXC                  ; USART, RX Complete Handler
reti;   rjmp USART_UDRE                 ; USART, UDR Empty Handler
reti;   rjmp USART_TXC                  ; USART, TX Complete Handler
reti;   rjmp ADC                        ; ADC Conversion Complete Handler
reti;   rjmp EE_RDY                     ; EEPROM Ready Handler
reti;   rjmp ANA_COMP                   ; Analog Comparator Handler
reti;   rjmp TWI                        ; 2-wire Serial Interface Handler
reti;   rjmp                            ; SPM_RDYStore Program Memory Ready

RESET:
        rjmp Main                       ;    
.org    $100
.include "DATA.asm"                     ;    FLASH    
.include "EXT_INT1.asm"                 ;    INT1
.include "TIM0_COMPA.asm"               ;      0

;***********************************************************************************************************************
;* 150213-02                              
;***********************************************************************************************************************
Main:   
        ldi     temp,low(RAMEND)        ;     
        out     SPL,temp
        ldi     temp,high(RAMEND)
        out     SPH,temp

;--------------------------------------   - --------------------------------------------------

        INIT_PORTS                      ;   -
        CLR_REG_SHIFT                   ;       
        CLR_REG_LATCH                   ;       
        SET_SEGA12_7                    ;     SEGA 

;--------------------------------------     ----------------------------------------

        ldi     yh,1                    ;     
        rcall   ClearOutBuf             ;    -    
        rcall   OutBufToRegs            ;      

;--------------------------------------    INT1 ----------------------------------------------

;         ldi     temp,(1<<ISC11)         ;   INT1     PS/2 
;         sts     EICRA,temp
;         ldi     temp,(1<<INT1)
;         out     EIMSK,temp
;--------------------------------------     0   50  ---------------------------

        ldi     temp,(1<<WGM01)         ;  CTC (  )
        out     TCCR0A,temp
        ldi     temp,(1<<CS01)          ;   clk/8
        out     TCCR0B,temp
        ldi     temp,68                 ;    0  68
        out     OCR0A,temp              ;    T=(8*69)/11.0592=49.9 
        ldi     temp,(1<<OCIE0A)        ;      =68
        sts     TIMSK0,temp
;--------------------------------------   -    -------------------------
;                                            

        rcall   Delay1S                 ;  1 
        sei                             ;  

Main_80:

        rcall   ClearOutBuf             ;    -    
        rcall   ReadSegaJoy             ;  SEGA 
        rcall   WorkSegaData            ;    SEGA 
        rcall   OutBufToRegs            ;      

        rjmp    Main_80

;***********************************************************************************************************************
;* 150211-01                               -    
;***********************************************************************************************************************
ClearOutBuf:
        ldi     yl,0                    ;     
        ldi     cnt_out_buf,72          ;    -   
        ldi     temp,1

ClearOutBuf_10:
        st      y+,temp                 ;     1,      
        dec     cnt_out_buf             ;         1 -  
        brne    ClearOutBuf_10

        ret

;***********************************************************************************************************************
;* 150210-02                             SEGA 
;***********************************************************************************************************************
ReadSegaJoy:
        ret

;***********************************************************************************************************************
;* 150211-02                               SEGA 
;***********************************************************************************************************************
WorkSegaData:
        ldi     yl,KEY_1                ;        "1"
        ldi     temp,0                  ;  0 (  )
        st      y,temp                  ;     
        ret

;***********************************************************************************************************************
;* 150213-01                                 
;***********************************************************************************************************************
OutBufToRegs:
        ldi     yl,0                    ;     
;--------------------------------------  DD10 -------------------------------------------------------------------
        SHIFT_KEY_TO_REGS               ;         
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
;--------------------------------------  DD9 --------------------------------------------------------------------
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS                      ;   
        SHIFT_REGS
        SHIFT_REGS
;--------------------------------------  DD8 --------------------------------------------------------------------
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
;--------------------------------------  DD7 --------------------------------------------------------------------
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_REGS
;--------------------------------------  DD6 --------------------------------------------------------------------
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
;--------------------------------------  DD5 --------------------------------------------------------------------
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_REGS
;--------------------------------------  DD4 --------------------------------------------------------------------
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
;--------------------------------------  DD3 --------------------------------------------------------------------
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_REGS
;--------------------------------------  DD2 --------------------------------------------------------------------
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
;-----------------------------------------------------------------------------------------------------------------------
        LATCH_REGS                      ;         
        ret

;***********************************************************************************************************************
;* 150212-01                              1 
;***********************************************************************************************************************
Delay1S:
        ldi     cnt_delay0,$00
        ldi     cnt_delay1,$C0
        ldi     cnt_delay2,$21

Delay1S_10:
        subi    cnt_delay0,1
        sbci    cnt_delay1,0
        sbci    cnt_delay2,0
        brcc    Delay1S_10
        ret

;***********************************************************************************************************************
